clearvars
close all

iseed = 0;
repeats = 10;
dt = 10;
Lvalues = [20,50,80];
Lmarkers = {'ro','ko','bo','rx','kx','bx'};
formatSpec = '%f';
csmethods = [1,2];

theory=0.5;

for m=1:size(csmethods,2)
for j=1:size(Lvalues,2)
  L=Lvalues(j);
  FILENAME = sprintf('KL%dm%d.txt',L,m);
  fileID = fopen(FILENAME,'r');

  A = fscanf(fileID,formatSpec);
  B=zeros(19,50);
  for i=1:19
      B(i,:)=A((i-1)*50+1:i*50);
  end
  C=zeros(19,10);
  for i=1:10
      C(:,i)=B(:,i*5-4);
  end
  
  dt=zeros(1,19);
  for i=1:10
      dt(i)=i;
  end
  for i=1:9
      dt(i+10)=(i+1)*10;
  end
  hold on, plot(dt,mean(C,2)/L,Lmarkers{(m-1)*3+j},'MarkerSize',12,'LineWidth',2);
end
end

hold on, plot([1,100],[theory,theory],'k--','LineWidth',3.2);

set(gcf,'units','points','position',[10,10,400,300]);
set(gca, 'FontSize', 30);
set(gca, 'LineWidth', 4);

set(gca,'xscale','log')
set(gca,'YTick', [0.3,0.4,0.5]);
xlim([1,100]);
ylim([0.25,0.52]);

xlabel('$\Delta t$','interpreter','latex');
yname = '$\overline{k}$';
ylabel(yname,'interpreter','latex');

text(1.4,0.39,'$L=20$:','FontSize',24,'interpreter','latex');
hold on, plot(7,0.39,'ro','MarkerSize',12,'LineWidth',2);
text(8,0.39,'[iid]','FontSize',24,'interpreter','latex');
hold on, plot(22,0.39,'rx','MarkerSize',12,'LineWidth',2);
text(25,0.39,'[eq]','FontSize',24,'interpreter','latex');

text(1.4,0.35,'$L=50$:','FontSize',24,'interpreter','latex');
hold on, plot(7,0.35,'ko','MarkerSize',12,'LineWidth',2);
text(8,0.35,'[iid]','FontSize',24,'interpreter','latex');
hold on, plot(22,0.35,'kx','MarkerSize',12,'LineWidth',2);
text(25,0.35,'[eq]','FontSize',24,'interpreter','latex');

text(1.4,0.31,'$L=80$:','FontSize',24,'interpreter','latex');
hold on, plot(7,0.31,'bo','MarkerSize',12,'LineWidth',2);
text(8,0.31,'[iid]','FontSize',24,'interpreter','latex');
hold on, plot(22,0.31,'bx','MarkerSize',12,'LineWidth',2);
text(25,0.31,'[eq]','FontSize',24,'interpreter','latex');

hold on, plot([1.7,3.1],[0.275,0.275],'k--','LineWidth',3.2);
text(3.8,0.275,'Theory','FontSize',24,'interpreter','latex');

plotname = sprintf('KTau.png');
saveas(gcf,plotname);